 <!-- Modal -->
 <div class="modal custom--modal fade" id="buyPlanModal" role="dialog">
     <div class="modal-dialog" role="document">
         <div class="modal-content section-bg">
             <div class="modal-header">
                 <h5 class="modal-title"><?php echo app('translator')->get('Buy Trading Plan'); ?></h5>
                 <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                     <span aria-hidden="true">&times;</span>
                 </button>
             </div>
             <div class="modal-body">
                 <form action="<?php echo e(route('user.plan.order')); ?>" method="POST">
                     <?php echo csrf_field(); ?>
                     <input name="plan_id" type="hidden">

                     <div class="row gy-4">
                         <div class="text-center">
                             <ul class="list-group">
                                 <li class="list-group-item d-flex justify-content-between flex-wrap">
                                     <span>
                                         <strong><?php echo app('translator')->get('Title'); ?></strong>
                                     </span>
                                     <span class="plan-title"></span>
                                 </li>
                                 <li class="list-group-item d-flex justify-content-between flex-wrap">
                                     <span>
                                         <strong><?php echo app('translator')->get('Price'); ?></strong>
                                     </span>
                                     <div>
                                         <span class="plan-price"></span> <span><?php echo e(__(gs('cur_text'))); ?></span>
                                     </div>
                                 </li>
                             </ul>
                         </div>

                         <div class="col-sm-12">
                             <label for="paymentMethod"><?php echo app('translator')->get('Payment System'); ?></label>
                             <select class="form--control custom--select" id="paymentMethod" name="payment_method" required>
                                 <option value="" selected disabled><?php echo app('translator')->get('Select One'); ?></option>
                                 <option value="1"><?php echo app('translator')->get('From Balance'); ?></option>
                                 <option value="2"><?php echo app('translator')->get('Direct Payment'); ?></option>
                             </select>
                         </div>

                         <div class="col-sm-12">
                             <button class="btn--base w-100" type="submit"><?php echo app('translator')->get('Buy Now'); ?></button>
                         </div>
                     </div>
                 </form>
             </div>
         </div>
     </div>
 </div>

 <?php $__env->startPush('style'); ?>
     <style>
         .modal-content {
             text-align: unset !important;
         }

         .custom--modal .list-group-item:last-child {
             border-bottom: 1px solid #ffffff19;
         }
     </style>
 <?php $__env->stopPush(); ?>

 <?php $__env->startPush('script'); ?>
     <script>
         'use strict';
         (function($) {
             $(document).on('click', '.buy-plan', function() {
                 var modal = $('#buyPlanModal');
                 modal.find('input[name=plan_id]').val($(this).data('id'));
                 modal.find('.plan-title').text($(this).data('title'));
                 modal.find('.plan-price').text($(this).data('price'));
                 modal.modal('show');
             });
         })(jQuery);
     </script>
 <?php $__env->stopPush(); ?>
<?php /**PATH /home/postalde/console.vevercapital.com/core/resources/views/templates/dark/partials/buy_plan_modal.blade.php ENDPATH**/ ?>