<?php
    $footerCaption = getContent('footer.content', true);
    $contactCaption = getContent('contact_us.content', true);
    $pages = App\Models\Page::activeTemplate()->where('is_default', Status::NO)->get();
    $policyPages = getContent('policy_pages.element', false, null, true);
?>

<footer class="footer-area bg-img bg-overlay-one" style="background-image: url(<?php echo e(frontendImage('footer', @$footerCaption->data_values->background_image, '1900x650')); ?>);">
    <div class="footer-top py-50 container">
        <div class="row justify-content-center gy-5">
            <div class="col-xl-4 col-sm-6 pe-lg-5">
                <div class="footer-item">
                    <div class="footer-item__logo">
                        <a href="<?php echo e(route('home')); ?>"> <img src="<?php echo e(siteLogo()); ?>" alt="<?php echo e(gs('site_name')); ?>"></a>
                    </div>
                    <p class="footer-item__desc"><?php echo e(__(@$footerCaption->data_values->short_details)); ?></p>
                </div>
            </div>
            <div class="col-xl-2 col-sm-6">
                <div class="footer-item">
                    <h5 class="footer-item__title"> <?php echo app('translator')->get('Quick Links'); ?> </h5>
                    <ul class="footer-menu">
                        <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="footer-menu__item"><a class="footer-menu__link" href="<?php echo e(route('pages', ['slug' => $item->slug])); ?>"><?php echo e(__($item->name)); ?></a></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <li class="footer-menu__item"><a class="footer-menu__link" href="<?php echo e(route('plans')); ?>"><?php echo app('translator')->get('Trading Plans'); ?></a></li>
                        <li class="footer-menu__item"><a class="footer-menu__link" href="<?php echo e(route('blog')); ?>"><?php echo app('translator')->get('Blog'); ?></a></li>
                        <li class="footer-menu__item"><a class="footer-menu__link" href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a></li>
                    </ul>
                </div>
            </div>
            <div class="col-xl-3 col-sm-6">
                <div class="footer-item">
                    <h5 class="footer-item__title"><?php echo app('translator')->get('Useful Links'); ?></h5>
                    <ul class="footer-menu">
                        <?php $__currentLoopData = $policyPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="footer-menu__item"><a class="footer-menu__link" href="<?php echo e(route('policy.pages', $page->slug)); ?>"><?php echo e(__($page->data_values->title)); ?></a></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </ul>
                </div>
            </div>
            <div class="col-xl-3 col-sm-6">
                <div class="footer-item">
                    <h5 class="footer-item__title"><?php echo app('translator')->get('Contact Info'); ?> </h5>
                    <ul class="footer-contact-menu">
                        <li class="footer-contact-menu__item">
                            <div class="footer-contact-menu__item-icon">
                                <i class="las la-phone"></i>
                            </div>
                            <div class="footer-contact-menu__item-content">
                                <p><a href="tel:<?php echo e(@$contactCaption->data_values->contact_number); ?>"><?php echo e(@$contactCaption->data_values->contact_number); ?></a></p>
                            </div>
                        </li>
                        <li class="footer-contact-menu__item">
                            <div class="footer-contact-menu__item-icon">
                                <i class="lar la-envelope"></i>
                            </div>
                            <div class="footer-contact-menu__item-content">
                                <p><a href="mailto:<?php echo e(@$contactCaption->data_values->email_address); ?>"><?php echo e(@$contactCaption->data_values->email_address); ?></a></p>
                            </div>
                        </li>
                        <li class="footer-contact-menu__item">
                            <div class="footer-contact-menu__item-icon">
                                <i class="las la-map-marker-alt"></i>
                            </div>
                            <div class="footer-contact-menu__item-content">
                                <p><?php echo e(@$contactCaption->data_values->contact_details); ?></p>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="bottom-footer py-3">
        <div class="container">
            <div class="row gy-3">
                <div class="col-md-12 text-center">
                    <div class="bottom-footer-text text-white"><?php echo app('translator')->get('Copyright'); ?> &copy; <?php echo e(date('Y')); ?> <a class="text--base" href="<?php echo e(route('home')); ?>"><?php echo e(gs('site_name')); ?></a>. <?php echo app('translator')->get('All rights reserved'); ?></div>
                </div>
            </div>
        </div>
    </div>
</footer>
<?php /**PATH /home/postalde/console.vevercapital.com/core/resources/views/templates/dark/partials/footer.blade.php ENDPATH**/ ?>