<?php
    $content = getContent('blog.content', true);
    $blogs = getContent('blog.element', false, 3);
?>

<section class="blog py-100">
    <div class="container">
        <div class="row">
            <div class="section-heading">
                <h3 class="section-heading__title"><?php echo e(__(@$content->data_values->heading)); ?></h3>
                <p class="section-heading__desc"><?php echo e(__(@$content->data_values->description)); ?></p>
            </div>
        </div>
        <div class="row gy-4 justify-content-center">
            <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4 col-md-6">
                    <div class="blog-item">
                        <div class="blog-item__thumb">
                            <a class="blog-item__thumb-link" href="<?php echo e(route('blog.details', $blog->slug)); ?>"><img src="<?php echo e(frontendImage('blog', 'thumb_' . @$blog->data_values->blog_image, '300x200')); ?>" alt="<?php echo e($blog->data_values->title); ?>"></a>
                            <span class="blog-item__date"> <span class="blog-item__date-icon"><i class="fas fa-calendar-alt"></i></span> <?php echo e(showDateTime($blog->created_at, 'd, M')); ?> </span>
                        </div>
                        <div class="blog-item__content">
                            <h4 class="blog-item__title"><a class="blog-item__title-link" href="<?php echo e(route('blog.details', $blog->slug)); ?>"><?php echo e(__($blog->data_values->title)); ?></a></h4>
                            <p class="blog-item__desc"><?php echo strLimit(strip_tags($blog->data_values->description), 80) ?></p>
                            <a class="btn--simple" href="<?php echo e(route('blog.details', $blog->slug)); ?>"><?php echo app('translator')->get('Read More'); ?> <span class="btn--simple__icon"><i class="las la-chevron-right"></i></span> </a>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php /**PATH /home/postalde/console.vevercapital.com/core/resources/views/templates/dark/sections/blog.blade.php ENDPATH**/ ?>