<?php
    $content = getContent('faq.content', true);
    $elements = getContent('faq.element', false, null, true);
    $elements = $elements->chunk(ceil($elements->count() / 2));
?>

<section class="faq py-100 section-bg">
    <div class="container">
        <div class="row">
            <div class="section-heading">
                <h3 class="section-heading__title"><?php echo e(__(@$content->data_values->heading)); ?></h3>
                <p class="section-heading__desc"><?php echo e(__(@$content->data_values->description)); ?></p>
            </div>
        </div>
        <div class="row gy-3">
            <div class="col-lg-6 pe-lg-5">
                <div class="accordion custom--accordion" id="accordionExample">

                    <?php $__currentLoopData = @$elements[0] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="leftHeading<?php echo e($item->id); ?>">
                                <button class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#leftCollapse<?php echo e($item->id); ?>" type="button" aria-expanded="false" aria-controls="leftCollapse<?php echo e($item->id); ?>">
                                    <?php echo e(__($item->data_values->question)); ?>

                                </button>
                            </h2>
                            <div class="accordion-collapse collapse" id="leftCollapse<?php echo e($item->id); ?>" data-bs-parent="#accordionExample" aria-labelledby="leftHeading<?php echo e($item->id); ?>">
                                <div class="accordion-body">
                                    <p class="accordion-body__desc">
                                        <?php echo e(__($item->data_values->answer)); ?>

                                    </p>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="accordion custom--accordion" id="accordionExample2">
                    <?php $__currentLoopData = @$elements[1] ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="rightHeading<?php echo e($item->id); ?>">
                                <button class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#rightCollapse<?php echo e($item->id); ?>" type="button" aria-expanded="false" aria-controls="rightCollapse<?php echo e($item->id); ?>">
                                    <?php echo e(__($item->data_values->question)); ?>

                                </button>
                            </h2>
                            <div class="accordion-collapse collapse" id="rightCollapse<?php echo e($item->id); ?>" data-bs-parent="#accordionExample2" aria-labelledby="rightHeading<?php echo e($item->id); ?>">
                                <div class="accordion-body">
                                    <p class="accordion-body__desc">
                                        <?php echo e(__($item->data_values->answer)); ?>

                                    </p>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH /home/postalde/console.vevercapital.com/core/resources/views/templates/dark/sections/faq.blade.php ENDPATH**/ ?>