<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table--light style--two custom-data-table table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('S.N.'); ?></th>
                                    <th><?php echo app('translator')->get('Title'); ?></th>
                                    <th><?php echo app('translator')->get('Miner'); ?></th>
                                    <th><?php echo app('translator')->get('Price'); ?></th>
                                    <th><?php echo app('translator')->get('Speed'); ?></th>
                                    <th><?php echo app('translator')->get('Period'); ?></th>
                                    <th><?php echo app('translator')->get('Return /Day'); ?></th>
                                    <th><?php echo app('translator')->get('Maintenance'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody class="list">
                                <?php $__empty_1 = true; $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td> <?php echo e($plans->firstItem() + $loop->index); ?></td>
                                        <td> <?php echo e(__($plan->title)); ?> </td>
                                        <td> <?php echo e(__(@$plan->miner->name)); ?> </td>
                                        <td> <?php echo e(showAmount($plan->price)); ?></td>
                                        <td> <?php echo e($plan->speed); ?> <?php echo e($plan->speedUnitText); ?> </td>
                                        <td> <?php echo e($plan->period); ?> <?php echo e($plan->periodUnitText); ?></td>
                                        <td> <?php echo e($plan->returnPerDay); ?> <?php echo e(strtoupper(@$plan->miner->coin_code)); ?> </td>
                                        <td> <?php echo e(getAmount($plan->maintenance_cost)); ?> % </td>
                                        <td>
                                            <?php
                                                echo $plan->statusBadge;
                                            ?>
                                        </td>
                                        <td>
                                            <div class="button--group">
                                                <button class="btn btn-outline--primary btn-sm editBtn"
                                                    data-plan="<?php echo e($plan); ?>">
                                                    <i class="la la-pencil"></i><?php echo app('translator')->get('Edit'); ?>
                                                </button>

                                                <?php if($plan->status == Status::DISABLE): ?>
                                                    <button type="button"
                                                        class="btn btn-sm btn-outline--success  confirmationBtn"
                                                        data-action="<?php echo e(route('admin.plan.status', $plan->id)); ?>"
                                                        data-question="<?php echo app('translator')->get('Are you sure to enable this plan?'); ?>">
                                                        <i class="la la-eye"></i><?php echo app('translator')->get('Enable'); ?>
                                                    </button>
                                                <?php else: ?>
                                                    <button type="button"
                                                        class="btn btn-sm btn-outline--danger confirmationBtn"
                                                        data-action="<?php echo e(route('admin.plan.status', $plan->id)); ?>"
                                                        data-question="<?php echo app('translator')->get('Are you sure to disable this plan?'); ?>">
                                                        <i class="la la-eye-slash"></i><?php echo app('translator')->get('Disable'); ?>
                                                    </button>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                </div>
                <?php if($plans->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($plans)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="addModal" role="dialog" tabindex="-1">
        <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Add Plan'); ?></h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="<?php echo e(route('admin.plan.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">
                            <div class="form-group col-lg-6">
                                <label><?php echo app('translator')->get('Title'); ?></label>
                                <input class="form-control" name="title" type="text" value="<?php echo e(old('title')); ?>"
                                    placeholder="<?php echo app('translator')->get('Enter Plan Title'); ?>" required />
                            </div>
                            <div class="form-group col-lg-6">
                                <label><?php echo app('translator')->get('Miner'); ?></label>
                                <select class="form-control" name="miner">
                                    <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                                    <?php $__currentLoopData = $miners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $miner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option data-coin_code=<?php echo e($miner->coin_code); ?> value="<?php echo e($miner->id); ?>"
                                            <?php if($miner->id == old('miner')): echo 'selected'; endif; ?>> <?php echo e(__($miner->name)); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="form-group col-lg-6">
                                <label><?php echo app('translator')->get('Price'); ?></label>
                                <div class="input-group">
                                    <span class="input-group-text"><?php echo e(gs('cur_sym')); ?></span>
                                    <input class="form-control" name="price" type="number" value="<?php echo e(old('price')); ?>"
                                        step="any" placeholder="<?php echo app('translator')->get('Enter Price'); ?>" required />
                                </div>
                            </div>

                            <div class="form-group col-lg-6">
                                <label><?php echo app('translator')->get('Return Amount Type'); ?></label>
                                <select class="form-control" name="return_type">
                                    <option value="1" <?php if(old('return_type') == 1): echo 'selected'; endif; ?>><?php echo app('translator')->get('Fixed'); ?></option>
                                    <option value="2" <?php if(old('return_type') == 2): echo 'selected'; endif; ?>><?php echo app('translator')->get('Random'); ?></option>
                                </select>
                            </div>

                            <div class="col-12 return-type-wrapper">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Return Amount /Day'); ?></label>
                                    <div class="input-group">
                                        <input class="form-control" name="return_per_day" type="number"
                                            value="<?php echo e(old('return_per_day')); ?>" step="any"
                                            placeholder="<?php echo app('translator')->get('Enter Return Per Day'); ?>" required />
                                        <span class="input-group-text rpd_cur_sym"><?php echo e(gs('cur_text')); ?></span>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group col-lg-4">
                                <label><?php echo app('translator')->get('Speed'); ?></label>
                                <div class="input-group">
                                    <input class="form-control" name="speed" type="number" step="any"
                                        placeholder="<?php echo app('translator')->get('Enter Speed Value'); ?>" required />
                                    <select class="input-group-text" name="speed_unit">
                                        <option value="0"><?php echo app('translator')->get('hash/s'); ?></option>
                                        <option value="1"><?php echo app('translator')->get('Khash/s'); ?></option>
                                        <option value="2" selected><?php echo app('translator')->get('Mhash/s'); ?></option>
                                        <option value="3"><?php echo app('translator')->get('Ghash/s'); ?></option>
                                        <option value="4"><?php echo app('translator')->get('Thash/s'); ?></option>
                                        <option value="5"><?php echo app('translator')->get('Phash/s'); ?></option>
                                        <option value="6"><?php echo app('translator')->get('Ehash/s'); ?></option>
                                        <option value="7"><?php echo app('translator')->get('Zhash/s'); ?></option>
                                        <option value="8"><?php echo app('translator')->get('Yhash/s'); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group col-lg-4">
                                <label><?php echo app('translator')->get('Period'); ?></label>
                                <div class="input-group">
                                    <input class="form-control" name="period" type="number" step="any"
                                        placeholder="<?php echo app('translator')->get('Enter Period Value'); ?>" required />
                                    <select class="input-group-text" name="period_unit">
                                        <option value="0" <?php if(old('period') == 0): echo 'selected'; endif; ?>><?php echo app('translator')->get('Day'); ?></option>
                                        <option value="1" <?php if(old('period') == 1): echo 'selected'; endif; ?>><?php echo app('translator')->get('Month'); ?></option>
                                        <option value="2" <?php if(old('period') == 2): echo 'selected'; endif; ?>><?php echo app('translator')->get('Year'); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group col-lg-4">
                                <label><?php echo app('translator')->get('Maintenance Cost'); ?></label>
                                <div class="input-group">
                                    <input class="form-control" name="maintenance_cost" type="number" step="any"
                                        value="<?php echo e(old('maintenance_cost')); ?>" required />
                                    <span class="input-group-text"><?php echo app('translator')->get('% Per Day'); ?></span>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label><?php echo app('translator')->get('Features'); ?></label>
                            <select class="form-control select2-auto-tokenize" name="features[]" multiple>
                            </select>
                        </div>

                        <div class="form-group">
                            <label><?php echo app('translator')->get('Description'); ?></label>
                            <textarea class="form-control" name="description" rows="5"><?php echo e(old('descripiton')); ?></textarea>
                        </div>

                        <button class="btn btn-block btn--primary w-100 h-45" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="editModal" role="dialog" tabindex="-1">
        <div class="modal-dialog modal-xl modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form id="editForm" action="" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">
                            <div class="form-group col-lg-6">
                                <label><?php echo app('translator')->get('Title'); ?></label>
                                <input class="form-control" name="title" type="text" value="<?php echo e(old('title')); ?>"
                                    placeholder="<?php echo app('translator')->get('Enter Plan Title'); ?>" required />
                            </div>
                            <div class="form-group col-lg-6">
                                <label><?php echo app('translator')->get('Miner'); ?></label>
                                <select class="form-control" name="miner">
                                    <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                                    <?php $__currentLoopData = $miners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $miner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option data-coin_code=<?php echo e($miner->coin_code); ?> value="<?php echo e($miner->id); ?>"
                                            <?php if(old('miner') == $miner->id): echo 'selected'; endif; ?>> <?php echo e(__($miner->name)); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="form-group col-lg-6">
                                <label><?php echo app('translator')->get('Price'); ?></label>
                                <div class="input-group">
                                    <span class="input-group-text"><?php echo e(gs('cur_sym')); ?></span>
                                    <input class="form-control" name="price" type="number"
                                        value="<?php echo e(old('price')); ?>" step="any" placeholder="<?php echo app('translator')->get('Enter Price'); ?>"
                                        required />
                                </div>
                            </div>

                            <div class="form-group col-lg-6">
                                <label><?php echo app('translator')->get('Return Amount Type'); ?></label>
                                <select class="form-control" name="return_type">
                                    <option value="1" <?php if(old('return_type') == 1): echo 'selected'; endif; ?>><?php echo app('translator')->get('Fixed'); ?></option>
                                    <option value="2" <?php if(old('return_type') == 2): echo 'selected'; endif; ?>><?php echo app('translator')->get('Random'); ?></option>
                                </select>
                            </div>

                            <div class="col-12 return-type-wrapper">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Return Amount /Day'); ?></label>
                                    <div class="input-group">
                                        <input class="form-control" name="return_per_day" type="number"
                                            value="<?php echo e(old('return_per_day')); ?>" step="any"
                                            placeholder="<?php echo app('translator')->get('Enter Return Per Day'); ?>" required />
                                        <span class="input-group-text rpd_cur_sym"><?php echo e(gs('cur_text')); ?></span>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group col-lg-4">
                                <label><?php echo app('translator')->get('Speed'); ?></label>
                                <div class="input-group">
                                    <input class="form-control" name="speed" type="number" step="any"
                                        placeholder="<?php echo app('translator')->get('Enter Speed Value'); ?>" required />
                                    <select class="input-group-text" name="speed_unit">
                                        <option value="0"><?php echo app('translator')->get('hash/s'); ?></option>
                                        <option value="1"><?php echo app('translator')->get('Khash/s'); ?></option>
                                        <option value="2" selected><?php echo app('translator')->get('Mhash/s'); ?></option>
                                        <option value="3"><?php echo app('translator')->get('Ghash/s'); ?></option>
                                        <option value="4"><?php echo app('translator')->get('Thash/s'); ?></option>
                                        <option value="5"><?php echo app('translator')->get('Phash/s'); ?></option>
                                        <option value="6"><?php echo app('translator')->get('Ehash/s'); ?></option>
                                        <option value="7"><?php echo app('translator')->get('Zhash/s'); ?></option>
                                        <option value="8"><?php echo app('translator')->get('Yhash/s'); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group col-lg-4">
                                <label><?php echo app('translator')->get('Period'); ?></label>
                                <div class="input-group">
                                    <input class="form-control" name="period" type="number" step="any"
                                        placeholder="<?php echo app('translator')->get('Enter Period Value'); ?>" required />
                                    <select class="input-group-text" name="period_unit">
                                        <option value="0" <?php if(old('period') == 0): echo 'selected'; endif; ?>><?php echo app('translator')->get('Day'); ?></option>
                                        <option value="1" <?php if(old('period') == 1): echo 'selected'; endif; ?>><?php echo app('translator')->get('Month'); ?></option>
                                        <option value="2" <?php if(old('period') == 2): echo 'selected'; endif; ?>><?php echo app('translator')->get('Year'); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group col-lg-4">
                                <label><?php echo app('translator')->get('Maintenance Cost'); ?></label>
                                <div class="input-group">
                                    <input class="form-control" name="maintenance_cost" type="number" step="any"
                                        required />
                                    <span class="input-group-text"><?php echo app('translator')->get('% Per Day'); ?></span>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label><?php echo app('translator')->get('Features'); ?></label>
                            <select class="form-control select2-auto-tokenize" name="features[]"
                                multiple="multiple"></select>
                        </div>

                        <div class="form-group">
                            <label><?php echo app('translator')->get('Description'); ?></label>
                            <textarea class="form-control" name="description" rows="5"><?php echo e(old('descripiton')); ?></textarea>
                        </div>

                        <button class="btn btn-block btn--primary w-100 h-45" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php if (isset($component)) { $__componentOriginalbd5922df145d522b37bf664b524be380 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbd5922df145d522b37bf664b524be380 = $attributes; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ConfirmationModal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $attributes = $__attributesOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__attributesOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $component = $__componentOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__componentOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <button class="btn btn-outline--primary <?php if(request()->routeIs('admin.plan.index')): ?> h-45 <?php else: ?> btn-sm <?php endif; ?> addBtn"><i
            class="las la-plus"></i><?php echo app('translator')->get('Add New'); ?></button>
    <?php if(request()->routeIs('admin.plan.index')): ?>
        <?php if (isset($component)) { $__componentOriginale48b4598ffc2f41a085f001458a956d1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale48b4598ffc2f41a085f001458a956d1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.search-form','data' => ['placeholder' => 'Search by title/Miner']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('search-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['placeholder' => 'Search by title/Miner']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $attributes = $__attributesOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__attributesOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $component = $__componentOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__componentOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
    <?php else: ?>
        <a class="btn btn-sm btn-outline--dark" href="<?php echo e(route('admin.miner.index')); ?>"><i
                class="las la-undo"></i><?php echo app('translator')->get('Back'); ?></a>
    <?php endif; ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        'use strict';
        (function($) {
            $('.addBtn').on('click', function() {
                var modal = $('#addModal');
                modal.find('form').trigger("reset");
                let currentMiner = <?php echo json_encode(@$currentMiner->id, 15, 512) ?>;
                modal.find('select[name=miner]').val(currentMiner).trigger("change");
                initSelect2AutoTokenize(modal);

                modal.modal('show');
            });


            $('.editBtn').on('click', function() {
                var modal = $('#editModal');
                var plan = $(this).data('plan');
                var form = document.getElementById('editForm');

                modal.find('.modal-title').text(`<?php echo app('translator')->get('Edit Plan -'); ?> ${plan.title}`);

                modal.find('input[name=title]').val(plan.title);
                modal.find('input[name=price]').val(parseFloat(plan.price));
                modal.find('.rpd_cur_sym').text(plan.miner.coin_code);
                modal.find('select[name=miner]').val(plan.miner_id);
                modal.find('input[name=speed]').val(plan.speed);
                modal.find('select[name=speed_unit]').val(plan.speed_unit);

                modal.find('input[name=period]').val(plan.period);
                modal.find('input[name=maintenance_cost]').val(plan.maintenance_cost);
                modal.find('select[name=period_unit]').val(plan.period_unit);


                if (!plan.max_return_per_day) {
                    modal.find('select[name=return_type]').val(1);
                    modal.find('.return-type-wrapper').html(`
                        <div class="form-group">
                            <label class="font-weight-bold"><?php echo app('translator')->get('Return Amount /Day'); ?></label>
                            <div class="input-group">
                                <input type="number" step="any" class="form-control" placeholder="<?php echo app('translator')->get('Enter Return Per Day'); ?>" name="return_per_day" required/>
                                <span class="input-group-text rpd_cur_sym"><?php echo e(gs('cur_text')); ?></span>
                            </div>
                        </div>
                `)
                    modal.find('input[name=return_per_day]').val(parseFloat(plan.min_return_per_day));

                } else {
                    modal.find('select[name=return_type]').val(2);
                    modal.find('.return-type-wrapper').html(`<div class="row">
                            <div class="form-group col-lg-6">
                                <label class="font-weight-bold"><?php echo app('translator')->get('Minimum Return Amount /Day'); ?></label>
                                <div class="input-group">
                                    <input type="number" step="any" class="form-control" placeholder="<?php echo app('translator')->get('Enter Return Per Day'); ?>" name="min_return_per_day" required/>
                                    <span class="input-group-text rpd_cur_sym"><?php echo e(gs('cur_text')); ?></span>
                                </div>
                            </div>

                            <div class="form-group col-lg-6">
                                <label class="font-weight-bold"><?php echo app('translator')->get('Maximum Return Amount /Day'); ?></label>
                                <div class="input-group">
                                    <input type="number" step="any" class="form-control" placeholder="<?php echo app('translator')->get('Enter Return Per Day'); ?>" name="max_return_per_day" required/>
                                    <span class="input-group-text rpd_cur_sym"><?php echo e(gs('cur_text')); ?></span>
                                </div>
                            </div>
                        </div>`)

                    modal.find('input[name=min_return_per_day]').val(parseFloat(plan.min_return_per_day));
                    modal.find('input[name=max_return_per_day]').val(parseFloat(plan.max_return_per_day));
                }

                var coinCode = modal.find('select[name=miner]').find(':selected').attr('data-coin_code');
                modal.find('.rpd_cur_sym').text(coinCode);

                if (plan.status == 0) {
                    modal.find('[name=status]').bootstrapToggle('off');
                } else {
                    modal.find('[name=status]').bootstrapToggle('on');
                }

                let selectedValues = '';
                $.each(plan.features, function(i, v) {
                    selectedValues += `<option value="${v}" selected>${v}</option>`;
                });

                modal.find('select[name="features[]"]').html(selectedValues);

                initSelect2AutoTokenize(modal);

                modal.find('textarea[name=description]').val(plan.description);


                form.action = '<?php echo e(route('admin.plan.update', '')); ?>' + '/' + plan.id;

                modal.modal('show');
            });



            $(document).on('change', 'select[name=miner]', function() {
                var coinCode = $(this).find(':selected').attr('data-coin_code');
                $(this).parents('.modal-body').find('.rpd_cur_sym').text(coinCode);
            });

            $(document).on('change', 'select[name=return_type]', function() {
                if ($(this).val() == 2) {
                    $(this).parents('.modal-body').find('.return-type-wrapper').html(`<div class="row">
                                <div class="form-group col-lg-6">
                                    <label class="font-weight-bold"><?php echo app('translator')->get('Minimum Return Amount /Day'); ?></label>
                                    <div class="input-group">
                                        <input type="number" step="any" class="form-control" placeholder="<?php echo app('translator')->get('Enter Return Per Day'); ?>" name="min_return_per_day" required/>
                                        <span class="input-group-text rpd_cur_sym"><?php echo e(gs('cur_text')); ?></span>
                                    </div>
                                </div>

                                <div class="form-group col-lg-6">
                                    <label class="font-weight-bold"><?php echo app('translator')->get('Maximum Return Amount /Day'); ?></label>
                                    <div class="input-group">
                                        <input type="number" step="any" class="form-control" placeholder="<?php echo app('translator')->get('Enter Return Per Day'); ?>" name="max_return_per_day" required/>
                                        <span class="input-group-text rpd_cur_sym"><?php echo e(gs('cur_text')); ?></span>
                                    </div>
                                </div>
                            </div>`).hide().show();
                } else {
                    $(this).parents('.modal-body').find('.return-type-wrapper').html(`
                                <div class="form-group">
                                    <label class="font-weight-bold"><?php echo app('translator')->get('Return Amount /Day'); ?></label>
                                    <div class="input-group">
                                        <input type="number" step="any" class="form-control" placeholder="<?php echo app('translator')->get('Enter Return Per Day'); ?>" name="return_per_day" required/>
                                        <span class="input-group-text rpd_cur_sym"><?php echo e(gs('cur_text')); ?></span>
                                    </div>
                                </div>
                            `).hide().show();
                }
                var coinCode = $(this).parents('.modal-body').find('select[name=miner]').find(':selected').attr(
                    'data-coin_code');
                $(this).parents('.modal-body').find('.rpd_cur_sym').text(coinCode);
            });

            function initSelect2AutoTokenize(modal) {
                modal.find('.select2-auto-tokenize').select2({
                    dropdownParent: modal,
                    tags: true,
                    tokenSeparators: [',']
                });
            }
        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/postalde/console.vevercapital.com/core/resources/views/admin/miner/plans.blade.php ENDPATH**/ ?>