<?php
    $content = getContent('testimonial.content', true);
    $testimonials = getContent('testimonial.element');
?>

<section class="testimonails py-100 section-bg">
    <div class="container">
        <div class="row">
            <div class="section-heading">
                <h3 class="section-heading__title"><?php echo e(__(@$content->data_values->heading)); ?></h3>
                <p class="section-heading__desc"><?php echo e(__(@$content->data_values->heading)); ?></p>
            </div>
        </div>
        <div class="row gy-4 testimonails-item-wrapper">
            <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4">
                    <div class="testimonails-item">
                        <div class="testimonails-item__content">
                            <div class="testimonails-item__icon"><i class="fas fa-quote-left"></i></div>
                            <p class="testimonails-item__desc"><?php echo e(__($testimonial->data_values->quote)); ?></p>
                        </div>
                        <div class="testimonails-item__info">
                            <div class="testimonails-item__thumb">
                                <img src="<?php echo e(frontendImage('testimonial', $testimonial->data_values->author_image, '128x128')); ?>" alt="<?php echo app('translator')->get('Client'); ?>">
                            </div>
                            <h6 class="testimonails-item__name"><?php echo e(__($testimonial->data_values->author)); ?></h6>
                            <span class="testimonails-item__designation"> <?php echo e(__($testimonial->data_values->designation)); ?></span>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php /**PATH /home/postalde/console.vevercapital.com/core/resources/views/templates/dark/sections/testimonial.blade.php ENDPATH**/ ?>