<?php $__env->startSection('content'); ?>
    <?php
        $content = getContent('contact_us.content', true);
        $socials = getContent('social_icon.element');
    ?>

    <section class="contact py-100 section-bg">
        <div class="container">
            <div class="row gy-4">
                <div class="col-lg-5 col-md-6">
                    <div class="contact-information">
                        <h3 class="contact-title"><?php echo e(__(@$content->data_values->heading)); ?></h3>

                        <div class="contact-information-wrapper">
                            <div class="contact-information__item">
                                <div class="contact-information__item-icon">
                                    <i class="fas fa-map-marker-alt"></i>
                                </div>
                                <div class="contact-information__content">
                                    <h5 class="contact-information__title"><?php echo app('translator')->get('Address'); ?></h5>
                                    <p class="contact-information__desc"> <?php echo e(__(@$content->data_values->contact_details)); ?>

                                    </p>
                                </div>
                            </div>
                            <div class="contact-information__item">
                                <div class="contact-information__item-icon">
                                    <i class="far fa-envelope"></i>
                                </div>
                                <div class="contact-information__content">
                                    <h5 class="contact-information__title"><?php echo app('translator')->get('Email Address'); ?></h5>
                                    <p class="contact-information__desc"><a
                                            href="mailto:<?php echo e(@$content->data_values->email_address); ?>"><?php echo e(@$content->data_values->email_address); ?></a>
                                    </p>
                                </div>
                            </div>
                            <div class="contact-information__item">
                                <div class="contact-information__item-icon">
                                    <i class="fas fa-phone"></i>
                                </div>
                                <div class="contact-information__content">
                                    <h5 class="contact-information__title"> <?php echo app('translator')->get('Phone Number'); ?> </h5>
                                    <p class="contact-information__desc"><a
                                            href="tel:<?php echo e(@$content->data_values->contact_number); ?>"><?php echo e(@$content->data_values->contact_number); ?></a>
                                    </p>
                                </div>
                            </div>
                            <?php if(count($socials)): ?>
                                <div class="contact-information__item">
                                    <h6 class="follow-title w-100 mb-2 me-2"> <?php echo app('translator')->get('Follow Us On'); ?></h6>
                                    <ul class="social-list">
                                        <?php $__currentLoopData = $socials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class="social-list__item"><a class="social-list__link"
                                                    href="<?php echo e($item->data_values->url); ?>"
                                                    target="_blank"><?php echo $item->data_values->social_icon ?></a></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-7 col-md-6 ps-lg-5">
                    <div class="contact-form">
                        <form action="#" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-12">
                                    <div class="form-group">
                                        <input class="form--control" name="name" type="text"
                                            value="<?php echo e(auth()->user() ? auth()->user()->fullname : old('name')); ?>"
                                            <?php if(auth()->user() && auth()->user()->profile_complete): ?> readonly <?php endif; ?>
                                            placeholder="<?php echo app('translator')->get('Your Name'); ?>" required>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group">
                                        <input class="form--control" name="email" type="text"
                                            value="<?php echo e(auth()->user() ? auth()->user()->email : old('email')); ?>"
                                            <?php if(auth()->user() && auth()->user()->profile_complete): ?> readonly <?php endif; ?>
                                            placeholder="<?php echo app('translator')->get('Your Email'); ?>" required>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="form-group">
                                        <input class="form--control" name="subject" type="text"
                                            value="<?php echo e(old('subject')); ?>" placeholder="<?php echo app('translator')->get('Subject'); ?>" required>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <div class="form-group">
                                        <textarea class="form--control" name="message" placeholder="<?php echo app('translator')->get('Your Message'); ?>" required><?php echo e(old('message')); ?></textarea>
                                    </div>
                                </div>

                                <div class="col-12">
                                    <?php if (isset($component)) { $__componentOriginalff0a9fdc5428085522b49c68070c11d6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalff0a9fdc5428085522b49c68070c11d6 = $attributes; } ?>
<?php $component = App\View\Components\Captcha::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Captcha::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $attributes = $__attributesOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $component = $__componentOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__componentOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
                                </div>

                                <div class="col-12">
                                    <button class="btn--base w-100" id="recaptcha" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php if($sections->secs != null): ?>
        <?php $__currentLoopData = json_decode($sections->secs); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo $__env->make($activeTemplate . 'sections.' . $sec, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/postalde/console.vevercapital.com/core/resources/views/templates/dark/contact.blade.php ENDPATH**/ ?>