<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table--light style--two custom-data-table table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('S.N.'); ?></th>
                                    <th><?php echo app('translator')->get('Image'); ?></th>
                                    <th><?php echo app('translator')->get('Name'); ?></th>
                                    <th><?php echo app('translator')->get('Coin Code'); ?></th>
                                    <th><?php echo app('translator')->get('Plans'); ?></th>
                                    <th><?php echo app('translator')->get('Withdrawal Limit'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody class="list">
                                <?php $__empty_1 = true; $__currentLoopData = $miners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $miner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php
                                        $miner->image_with_path = getImage(getFilePath('miner') . '/' . @$miner->coin_image, getFileSize('miner'));
                                    ?>
                                    <tr>
                                        <td> <?php echo e($miners->firstItem() + $loop->index); ?></td>
                                        <td>
                                            <div class="user">
                                                <div class="thumb">
                                                    <img src="<?php echo e($miner->image_with_path); ?>" alt="<?php echo app('translator')->get('image'); ?>">
                                                </div>
                                            </div>
                                        </td>
                                        <td> <?php echo e(__($miner->name)); ?> </td>
                                        <td> <?php echo e(strtoupper($miner->coin_code)); ?> </td>
                                        <td> <?php echo e($miner->plans->count()); ?> </td>
                                        <td> <?php echo e(showAmount($miner->min_withdraw_limit, 8, exceptZeros: true, currencyFormat: false)); ?> - <?php echo e(showAmount($miner->max_withdraw_limit, 8, exceptZeros: true, currencyFormat: false)); ?> <?php echo e(strtoupper($miner->coin_code)); ?></td>
                                        <td>
                                            <div class="d-flex justify-content-end flex-wrap gap-2">
                                                <a class="btn btn-outline--dark btn-sm" href="<?php echo e(route('admin.miner.plans', $miner->id)); ?>">
                                                    <i class="las la-list"></i><?php echo app('translator')->get('View Plans'); ?>
                                                </a>

                                                <button class="btn btn-outline--primary btn-sm editBtn cuModalBtn" data-resource="<?php echo e($miner); ?>" data-modal_title="<?php echo app('translator')->get('Update Miner'); ?>">
                                                    <i class="las la-pen"></i><?php echo app('translator')->get('Edit'); ?>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                </div>
                <?php if($miners->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($miners)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    
    <div class="modal fade" id="cuModal" role="dialog" tabindex="-1">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button class="close" data-bs-dismiss="modal" type="button" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form action="<?php echo e(route('admin.miner.store')); ?>" method="POST" enctype="multipart/form-data">
                    <div class="modal-body">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-lg-4">
                                <div class="d-flex justify-content-center">
                                    <div class="form-group">
                                        <label class="required"><?php echo app('translator')->get('Image'); ?></label>
                                        <div class="miner-image">
                                            <div class="thumb">
                                                <div class="avatar-preview">
                                                    <div class="profilePicPreview" style="background-image: url('<?php echo e(getImage(null, getFileSize('miner'))); ?>')"></div>
                                                </div>
                                                <div class="avatar-edit">
                                                    <input class="profilePicUpload" id="image" name="coin_image" type="file" accept=".png, .jpg, .jpeg">
                                                    <label class="bg--primary" for="image"><i class="la la-pencil"></i></label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-8">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Miner Name'); ?></label>
                                    <input class="form-control" name="name" type="text" value="<?php echo e(old('name')); ?>" placeholder="<?php echo app('translator')->get('Enter Miner Name'); ?>" required />
                                </div>

                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Coin Code'); ?></label>
                                    <input class="form-control" name="coin_code" type="text" value="<?php echo e(old('coin_code')); ?>" placeholder="<?php echo app('translator')->get('Enter Coin Code'); ?>" required />
                                </div>
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Minimum Withdrawal Limit'); ?></label>
                                    <div class="input-group">
                                        <input class="form-control" name="min_withdraw_limit" type="number" value="<?php echo e(old('min_withdraw_limit')); ?>" step="any" placeholder="<?php echo app('translator')->get('Enter Minimum withdrawal Limit'); ?>" required />
                                        <span class="input-group-text"></span>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Maximum Withdrawal Limit'); ?></label>
                                    <div class="input-group">
                                        <input class="form-control" name="max_withdraw_limit" type="number" value="<?php echo e(old('max_withdraw_limit')); ?>" step="any" placeholder="<?php echo app('translator')->get('Enter Maximum Withdrawal Limit'); ?>" required />
                                        <span class="input-group-text"></span>
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--primary w-100 h-45" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <button class="btn btn-outline--primary h-45 cuModalBtn" data-modal_title="<?php echo app('translator')->get('Add Miner'); ?>" type="button">
        <i class="las la-plus"></i><?php echo app('translator')->get('Add New '); ?>
    </button>
    <?php if (isset($component)) { $__componentOriginale48b4598ffc2f41a085f001458a956d1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale48b4598ffc2f41a085f001458a956d1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.search-form','data' => ['placeholder' => 'Search by Name']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('search-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['placeholder' => 'Search by Name']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $attributes = $__attributesOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__attributesOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $component = $__componentOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__componentOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";

        function proPicURL(input) {
            if (input.files && input.files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    var preview = $(input).closest('.miner-image').find('.profilePicPreview');
                    $(preview).css('background-image', 'url(' + e.target.result + ')');
                    $(preview).addClass('has-image');
                    $(preview).hide();
                    $(preview).fadeIn(650);
                }
                reader.readAsDataURL(input.files[0]);
            }
        }
        $(".profilePicUpload").on('change', function() {
            proPicURL(this);
        });
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .miner-image .thumb {
            width: 220px;
            position: relative;
            margin-bottom: 30px;
        }

        .miner-image .thumb .profilePicPreview {
            width: 210px;
            height: 210px;
            display: block;
            border: 3px solid #f1f1f1;
            box-shadow: 0 0 5px 0 rgb(0 0 0 / 25%);
            border-radius: 10px;
            background-size: cover;
            background-position: center;
        }

        .miner-image .thumb .avatar-edit {
            position: absolute;
            bottom: -15px;
            right: 0;
        }

        .miner-image .thumb .profilePicUpload {
            font-size: 0;
            opacity: 0;
            width: 0;
        }

        .miner-image .thumb .avatar-edit label {
            width: 45px;
            height: 45px;
            border-radius: 50%;
            text-align: center;
            line-height: 45px;
            border: 2px solid #fff;
            font-size: 18px;
            cursor: pointer;
        }

        table .user {
            justify-content: center;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";

            $('[name=coin_code]').on('input', function() {
                $('#cuModal').find('.input-group-text').text($(this).val());
            });

            $('.editBtn').on('click', function() {
                let resource = $(this).data('resource');
                $('#cuModal').find('.input-group-text').text(resource.coin_code);
            });

            $("#cuModal").on('hidden.bs.modal', function() {
                $(this).find('.input-group-text').text('');
                $(this).find('.profilePicPreview').css("background-image", "url('<?php echo e(getImage(null, getFileSize('miner'))); ?>')");
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/postalde/console.vevercapital.com/core/resources/views/admin/miner/index.blade.php ENDPATH**/ ?>