<?php
    $contactCaption = getContent('contact_us.content', true);
    $pages = App\Models\Page::where('is_default', Status::NO)
        ->where('tempname', $activeTemplate)
        ->get();

    if (gs('multi_language')) {
        $language = getLanguages();
        $default = getLanguages(true);
    }
?>

<header class="header-bottom" id="header">
    <div class="container">
        <nav class="navbar navbar-expand-lg navbar-light">
            <a class="navbar-brand logo" href="<?php echo e(route('home')); ?>">
                <img src="<?php echo e(siteLogo()); ?>" alt="Logo">
            </a>
            <button class="navbar-toggler header-button" data-bs-toggle="collapse"
                data-bs-target="#navbarSupportedContent" type="button" aria-controls="navbarSupportedContent"
                aria-expanded="false" aria-label="Toggle navigation">
                <span id="hiddenNav"><i class="las la-bars"></i></span>
            </button>
            <div class="navbar-collapse collapse" id="navbarSupportedContent">
                <ul class="navbar-nav nav-menu m-auto">
                    <li class="nav-item"><a class="nav-link <?php echo e(menuActive('home')); ?>"
                            href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('Home'); ?></a></li>
                    <?php $__currentLoopData = $pages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li class="nav-item"><a class="nav-link <?php echo e(menuActive('pages', $item->slug)); ?>"
                                href="<?php echo e(route('pages', ['slug' => $item->slug])); ?>"><?php echo e(__($item->name)); ?></a></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <li class="nav-item"><a class="nav-link <?php echo e(menuActive('plans')); ?>"
                            href="<?php echo e(route('plans')); ?>"><?php echo app('translator')->get('Trading Plans'); ?></a></li>
                    <li class="nav-item"><a class="nav-link <?php echo e(menuActive('blog')); ?>"
                            href="<?php echo e(route('blog')); ?>"><?php echo app('translator')->get('Blogs'); ?></a></li>
                    <li class="nav-item"><a class="nav-link <?php echo e(menuActive('contact')); ?>"
                            href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a></li>
                </ul>

                <div
                    class="langauge-registration d-flex flex-wrap flex-lg-nowrap align-items-center justify-content-between">
                    <?php if(gs('multi_language')): ?>
                        <div class="language dropdown">
                            <button class="language-wrapper" data-bs-toggle="dropdown" aria-expanded="false">
                                <div class="language-content">
                                    <div class="language_flag">
                                        <img src="<?php echo e(getImage(getFilePath('language') . '/' . $default->image, getFileSize('language'))); ?>"
                                            alt="">
                                    </div>
                                    <p class="language_text_select"><?php echo e(__($default->name)); ?></p>
                                </div>
                                <span class="collapse-icon"><i class="las la-angle-down"></i></span>
                            </button>
                            <div class="dropdown-menu langList_dropdow py-2" style="">
                                <ul class="langList">
                                    <?php $__currentLoopData = $language->where('code', '!=', $default->code); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lang): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li>
                                            <a href="<?php echo e(route('lang', $lang->code)); ?>" class="language-list">
                                                <div class="language_flag">
                                                    <img src="<?php echo e(getImage(getFilePath('language') . '/' . $lang->image, getFileSize('language'))); ?>"
                                                        alt="flag">
                                                </div>
                                                <p class="language_text"><?php echo e(__($lang->name)); ?></p>
                                            </a>
                                        </li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        </div>
                    <?php endif; ?>

                    <div class="d-flex align-items-center gap-sm-0 user-btn-group flex-wrap gap-1">
                        <?php if(auth()->guard()->guest()): ?>
                            <?php if(gs('registration')): ?>
                                <a class="btn--base btn--sm ms-sm-3 register-btn ms-0 outline"
                                    href="<?php echo e(route('user.register')); ?>"><?php echo app('translator')->get('Register'); ?></a>
                            <?php endif; ?>
                            <a class="btn--base btn--sm ms-sm-3 ms-0"
                                href="<?php echo e(route('user.login')); ?>"><?php echo app('translator')->get('Login'); ?></a>
                        <?php else: ?>
                            <?php if(!request()->routeIs('user*') && !request()->routeIs('ticket*')): ?>
                                <a class="btn--base btn--sm ms-sm-3 ms-0"
                                    href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
                            <?php endif; ?>
                            <a class="btn btn--danger btn--sm ms-sm-3 ms-0"
                                href="<?php echo e(route('user.logout')); ?>"><?php echo app('translator')->get('Logout'); ?></a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </nav>
    </div>
</header>
<?php /**PATH /home/postalde/console.vevercapital.com/core/resources/views/templates/dark/partials/header.blade.php ENDPATH**/ ?>